<?php 

require_once 'conexiones/conexion.php';
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_user'])) {
    // Obtener los datos del formulario
    $email = $_POST['email'];
    $password = $_POST['password'];
    $role = $_POST['role'];


    // Validar que los campos no estén vacíos
    if (empty($email) || empty($password) || empty($role)) {
        $error = "Todos los campos son obligatorios.";
    } else {
        try {
            // Encriptar la contraseña
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);

            // Insertar el nuevo usuario en la base de datos
            $stmt = $pdo->prepare("INSERT INTO usuarios (email, password, role, created_at) VALUES (?, ?, ?, NOW())");
            $stmt->execute([$email, $hashed_password, $role]);

            // Redirigir o mostrar un mensaje de éxito
            header('Location: usuarios.php');
            exit;
        } catch (PDOException $e) {
            $error = "Error al agregar el usuario: " . $e->getMessage();
        }
    }
}
 ?>